<?php
// Background email sender - dipanggil via CLI
error_reporting(E_ERROR);
session_start();

require_once __DIR__ . '/Module/autoload.php';
require_once __DIR__ . '/Module/mailbuilder/builder.php';
require_once __DIR__ . '/Construct.php';
require_once __DIR__ . '/Helper.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\SMTP;
use PHPMailer\PHPMailer\Exception;
use Core\Pandora;
use Helper\MainHelper;
use Template\MailBuilder;

// Get data from command line argument
$sessionData = $argv[1] ?? null;
if (!$sessionData) {
    exit("No session data provided\n");
}

// Decode session data
$data = json_decode(base64_decode($sessionData), true);

$core = new Pandora();
$helper = new MainHelper();
$mail = new PHPMailer(true);
$init = $core->init();

try {
    // Setup PHPMailer
    if ($init['smtpsend']) {
        $mail->isSMTP();
        $mail->SMTPDebug  = 0;
        $mail->SMTPAuth   = true;
        $mail->SMTPSecure = 'tls';
        $mail->Hostname   = 'pandora-id.vip';
        $mail->Host       = $init['smtphost'];
        $mail->Port       = $init['smtpport'];
        $mail->Username   = $init['smtpuser'];
        $mail->Password   = $init['smtppass'];
    } else {
        $mail->isMail();
    }
    
    $mail->isHTML();
    $mail->setFrom($data['frommail'], $data['fromname']);
    $mail->addAddress($data['to']);
    $mail->Subject = $data['subject'];
    $mail->Body    = $data['body'];

    $mail->send();
    $helper->writeDelivery('success', substr($data['subject'], 0, 70) . '...');
} catch (Exception $e) {
    $helper->writeDelivery('failed', substr($data['subject'], 0, 40) . '... - ' . $e->getMessage(), $data['body']);
}
?>
