<?php
// Cron job untuk process email queue
// Jalankan setiap 1-5 menit via cron: */1 * * * * php /path/to/process_email_queue.php

error_reporting(E_ERROR);
set_time_limit(300); // 5 minutes max

require_once __DIR__ . '/Module/autoload.php';
require_once __DIR__ . '/Construct.php';
require_once __DIR__ . '/Helper.php';

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use Core\Pandora;
use Helper\MainHelper;

$core = new Pandora();
$helper = new MainHelper();
$init = $core->init();

// Get all queue files
$queueDir = __DIR__ . '/Module/tmp/';
$queueFiles = glob($queueDir . 'email_queue_*.json');

if (empty($queueFiles)) {
    echo "No emails in queue\n";
    exit(0);
}

echo "Processing " . count($queueFiles) . " emails...\n";

foreach ($queueFiles as $queueFile) {
    try {
        // Read queue data
        $data = json_decode(file_get_contents($queueFile), true);
        
        if (!$data || !isset($data['option']) || !isset($data['msg'])) {
            unlink($queueFile); // Delete invalid queue
            continue;
        }
        
        $option = $data['option'];
        $msg = $data['msg'];
        
        // Send email
        $mail = new PHPMailer(true);
        
        if ($init['smtpsend']) {
            $mail->isSMTP();
            $mail->SMTPDebug  = 0;
            $mail->SMTPAuth   = true;
            $mail->SMTPSecure = 'tls';
            $mail->Hostname   = 'pandora-id.vip';
            $mail->Host       = $init['smtphost'];
            $mail->Port       = $init['smtpport'];
            $mail->Username   = $init['smtpuser'];
            $mail->Password   = $init['smtppass'];
        } else {
            $mail->isMail();
        }
        
        $mail->isHTML();
        $mail->setFrom($option['frommail'], $option['fromname']);
        $mail->addAddress($option['to']);
        $mail->Subject = $option['subject'];
        $mail->Body    = $msg;
        
        $mail->send();
        
        echo "✓ Sent: " . $option['subject'] . "\n";
        $helper->writeDelivery('success', substr($option['subject'], 0, 70) . '...');
        
        // Delete queue file after success
        unlink($queueFile);
        
    } catch (Exception $e) {
        echo "✗ Failed: " . $e->getMessage() . "\n";
        $helper->writeDelivery('failed', basename($queueFile) . ' - ' . $e->getMessage(), '');
        
        // Keep queue file for retry (max 24 hours old)
        if (time() - filemtime($queueFile) > 86400) {
            unlink($queueFile); // Delete old failed queue
        }
    }
    
    // Small delay to avoid overwhelming mail server
    usleep(100000); // 0.1 second
}

echo "Done processing queue\n";
?>
